'use strict'

class EntityAccessHelper {
    static fromEntity (entity) {
        return new EntityAccessHelper(entity)
    }
    static fromUuid (uuid) {
        return new EntityAccessHelper(entities[uuid])
    }
    constructor (entity) {
        this.entity = entity
    }
    entity

    get exists () {
        return !!this.entity
    }

    get name () {
        return this.entity.name
    }

    get uuid () {
        return this.entity.uuid
    }

    get self () {
        return this.entity.self
    }

    get actions () {
        return this.subTypeDef.actions
    }

    get type () {
        return this.entity.type
    }

    get typeDef () {
        if (!this.#typeDef) {
            this.#typeDef = entityRegistry[this.type]['_base']
            if (!this.#typeDef) {
                throw new Error(`Entity sub type ${this.type}:${this.subType} not found!`)
            }
        }
        return this.#typeDef
    }
    #typeDef

    get subType () {
        return this.entity.subType
    }

    get subTypeDef () {
        if (!this.#subTypeDef) {
            this.#subTypeDef = entityRegistry[this.type][this.subType]
            if (!this.#subTypeDef) {
                throw new Error(`Entity sub type ${this.type}:${this.subType} not found!`)
            }
        }
        return this.#subTypeDef
    }
    #subTypeDef

    get staticConfig () {
        if (!this.#staticConfig) {
            const entityTypeConfig = calculateStaticConfig(this.entity.config, this.typeDef.staticConfig || [])
            const staticSubTypeConfig = calculateStaticConfig(this.entity.config, this.subTypeDef.staticConfig || [])
            this.#staticConfig = {...entityTypeConfig, ...staticSubTypeConfig}
        }
        return this.#staticConfig
    }
    #staticConfig

    dynamicConfig (time) {
        if (!this.#dynamicConfig || this.#dynamicConfigTime !== time) {
            const entityTypeConfig = calculateDynamicConfig(time, this.entity.config, {}, this.typeDef.dynamicConfig || [])
            const entitySubTypeConfig = calculateDynamicConfig(time, this.entity.config, {}, this.subTypeDef.dynamicConfig || [])
            this.#dynamicConfig = {...entityTypeConfig, ...entitySubTypeConfig}
            this.#dynamicConfigTime = time
        }
        return this.#dynamicConfig
    }
    #dynamicConfig
    #dynamicConfigTime

    sample (paramName, t0, t1, tStep) {
        const paramConfig = this.subTypeDef.dynamicConfig.find(x => x.paramName === paramName)
        const sampleData = calculateSamples(paramName, this.entity.config, this.subTypeDef.dynamicConfig || {}, t0, t1, tStep)
        return {
            displayName: paramConfig.displayName,
            ...sampleData,
        }
    }

    combinedConfigs (time) {
        return {...this.staticConfig, ...this.dynamicConfig(time)}
    }

    init () {
        const typeSelf = this.typeDef.init(this.staticConfig)
        const subTypeSelf = this.subTypeDef.init(this.staticConfig)
        this.entity.self = {...typeSelf, ...subTypeSelf}       
    }
}
